﻿## Init Offset ##

init offset = -3

## Initisialize Speaking ##

init python: 

    # This will eventually be used to call the name of the speaking character
    speaking = None

    # This is used to find when the character is speaking this is now synced the the duration of a voice file.
    def while_speaking(name, speak_d, done_d, st, at):
        if renpy.music.is_playing('voice') and speaking == name:
            return speak_d, .1
        else:
            return done_d, None

    # Not too sure what `curried` means or does but god bless the Ren'Py documentation
    curried_while_speaking = renpy.curry(while_speaking)

    def WhileSpeaking(name, speaking_d, done_d=Null()):
        return DynamicDisplayable(curried_while_speaking(name, speaking_d, done_d))

    # This part is a callback you have to add to each character who you want to track if they are speaking or not when you define their character.
    def speaker_callback(name, event, **kwargs):
        global speaking
        speaking = name
       
        #if event == "show":
            #speaking = name
        #elif event == "slow_done":
            #speaking = None
        #elif event == "end":
            #speaking = None

    speaker = renpy.curry(speaker_callback)

## Transition Definitions ##

## Flash fades the screen to a solid white image in 0.1 seconds, stays white for 0.0 seconds and takes 0.5 seconds to fade out.
define flash = Fade(0.1, 0.0, 0.5, color="#fff")

## Fade is just a shorter name for me to use instead of writing out Dissolve(0.1) anytime I want an image to transition :P
## I normally use this transition to change characters facial expressions
define fade = Dissolve(0.1)

## Blinds uses a black and white image to tell the game the pattern to transition through, in this case blindstile.png is a series or black to white gradients that the engine interpolates the alpha to dissolve through (hopefully that makes sense I don't really know a good way to explain it other than a pattern based dissolve)
## I made this to emulate the Norn/Miel blinds transition as closely as possible, I normally use this only when a character appears on screen unless I want them to slide in from off screen.
define blinds = ImageDissolve(im.Tile("blindstile.png"), 0.3, 12)

## f2b and f2b are like flash but instead of white they 'fade to black' (hence f2b) and pink.
define f2b = Fade(0.5, 0.2, 0.5, color="#000")
define f2w = Fade(0.5, 0.2, 0.5, color="#fff")
define f2p = Fade(0.3, 0.3, 0.3, color="#ffaaec")
    
## Menu Image Definitions ##

image main_menu_base = Transform("gui/main_menu.png", yoffset=0, size=(1365, 1024)) if persistent.Rez else Transform("gui/main_menu.png", yoffset=0, size=(1024, 768))
image logo = Transform("gui/logo.png", xanchor=0.5, size=(640, 275))

image main_menu = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "main_menu_base",
    ((config.screen_width/2 - 320), (0.5)), "logo")

image game_menu = Transform("gui/game_menu.png", yoffset=0, size=(1365, 1024)) if persistent.Rez else Transform("gui/game_menu.png", yoffset=0, size=(1024, 768))
    
## Textbox ##

image textbox = Transform("gui/textbox.png", size=(1365, 150)) if persistent.Rez else Transform("gui/textbox.png", size=(1024, 150))
    
## Background Definitions ##

image white = Solid("#fff")
image black = Solid("#000")

image nc001a = Transform("nc001a.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc001a.png", yoffset=0, size=(1024, 768))
image nc002a = Transform("nc002a.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc002a.png", yoffset=0, size=(1024, 768))
image nc002b = Transform("nc002b.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc002b.png", yoffset=0, size=(1024, 768))
image nc003a = Transform("nc003a.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc003a.png", yoffset=0, size=(1024, 768))
image nc003b = Transform("nc003b.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc003b.png", yoffset=0, size=(1024, 768))
image nc004a = Transform("nc004a.png", yoffset=50, size=(1365, 1024)) if persistent.Rez else Transform("nc004a.png", yoffset=0, size=(1024, 768))
image nc005a = Transform("nc005a.png", yoffset=80, size=(1365, 1024)) if persistent.Rez else Transform("nc005a.png", yoffset=0, size=(1024, 768))
image nc006a = Transform("nc006a.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc006a.png", yoffset=0, size=(1024, 768))
image nc007a = Transform("nc007a.png", yoffset=50, size=(1365, 1024)) if persistent.Rez else Transform("nc007a.png", yoffset=0, size=(1024, 768))
image nc008a = Transform("nc008a.png", yoffset=250, size=(1365, 1024)) if persistent.Rez else Transform("nc008a.png", yoffset=0, size=(1024, 768))
image nc009a = Transform("nc009a.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc009a.png", yoffset=0, size=(1024, 768))
image nc010a = Transform("nc010a.png", yoffset=175, size=(1365, 1024)) if persistent.Rez else Transform("nc010a.png", yoffset=0, size=(1024, 768))
image nc011a = Transform("nc011a.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc011a.png", yoffset=0, size=(1024, 768))
image nc012a = Transform("nc012a.png", yoffset=125, size=(1365, 1024)) if persistent.Rez else Transform("nc012a.png", yoffset=0, size=(1024, 768))

## H-Scene Definitions ##

image ev001a base = Transform("ev001a.png", size=(1024, 768))

image ev001a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev001a base",
    ((config.screen_width - 1024), 0), "ev001a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev001a base") if persistent.Rez else Transform("ev001a.png", size=(1024, 768))
    
image ev001b base = Transform("ev001b.png", size=(1024, 768))

image ev001b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev001b base",
    ((config.screen_width - 1024), 0), "ev001b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev001b base") if persistent.Rez else Transform("ev001b.png", size=(1024, 768))

image ev001c base = Transform("ev001c.png", size=(1024, 768))

image ev001c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev001c base",
    ((config.screen_width - 1024), 0), "ev001c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev001c base") if persistent.Rez else Transform("ev001c.png", size=(1024, 768))

image ev001d base = Transform("ev001d.png", size=(1024, 768))

image ev001d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev001d base",
    ((config.screen_width - 1024), 0), "ev001d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev001d base") if persistent.Rez else Transform("ev001d.png", size=(1024, 768))

image ev001e base = Transform("ev001e.png", size=(1024, 768))

image ev001e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev001e base",
    ((config.screen_width - 1024), 0), "ev001e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev001e base") if persistent.Rez else Transform("ev001e.png", size=(1024, 768))

image ev001f base = Transform("ev001f.png", size=(1024, 768))

image ev001f comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev001f base",
    ((config.screen_width - 1024), 0), "ev001f base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev001f base") if persistent.Rez else Transform("ev001f.png", size=(1024, 768))

image ev001g base = Transform("ev001g.png", size=(1024, 768))

image ev001g comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev001g base",
    ((config.screen_width - 1024), 0), "ev001g base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev001g base") if persistent.Rez else Transform("ev001g.png", size=(1024, 768))


image ev002a base = Transform("ev002a.png", size=(1024, 768))

image ev002a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev002a base",
    ((config.screen_width - 1024), 0), "ev002a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev002a base") if persistent.Rez else Transform("ev002a.png", size=(1024, 768))

image ev002b base = Transform("ev002b.png", size=(1024, 768))

image ev002b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev002b base",
    ((config.screen_width - 1024), 0), "ev002b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev002b base") if persistent.Rez else Transform("ev002b.png", size=(1024, 768))

image ev002c base = Transform("ev002c.png", size=(1024, 768))

image ev002c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev002c base",
    ((config.screen_width - 1024), 0), "ev002c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev002c base") if persistent.Rez else Transform("ev002c.png", size=(1024, 768))

image ev002d base = Transform("ev002d.png", size=(1024, 768))

image ev002d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev002d base",
    ((config.screen_width - 1024), 0), "ev002d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev002d base") if persistent.Rez else Transform("ev002d.png", size=(1024, 768))


image ev003a base = Transform("ev003a.png", size=(1024, 768))

image ev003a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev003a base",
    ((config.screen_width - 1024), 0), "ev003a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev003a base") if persistent.Rez else Transform("ev003a.png", size=(1024, 768))

image ev003b base = Transform("ev003b.png", size=(1024, 768))

image ev003b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev003b base",
    ((config.screen_width - 1024), 0), "ev003b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev003b base") if persistent.Rez else Transform("ev003b.png", size=(1024, 768))

image ev003c base = Transform("ev003c.png", size=(1024, 768))

image ev003c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev003c base",
    ((config.screen_width - 1024), 0), "ev003c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev003c base") if persistent.Rez else Transform("ev003c.png", size=(1024, 768))

image ev003d base = Transform("ev003d.png", size=(1024, 768))

image ev003d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev003d base",
    ((config.screen_width - 1024), 0), "ev003d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev003d base") if persistent.Rez else Transform("ev003d.png", size=(1024, 768))

image ev003e base = Transform("ev003e.png", size=(1024, 768))

image ev003e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev003e base",
    ((config.screen_width - 1024), 0), "ev003e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev003e base") if persistent.Rez else Transform("ev003e.png", size=(1024, 768))

image ev003f base = Transform("ev003f.png", size=(1024, 768))

image ev003f comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev003f base",
    ((config.screen_width - 1024), 0), "ev003f base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev003f base") if persistent.Rez else Transform("ev003f.png", size=(1024, 768))

image ev003g base = Transform("ev003g.png", size=(1024, 768))

image ev003g comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev003g base",
    ((config.screen_width - 1024), 0), "ev003g base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev003g base") if persistent.Rez else Transform("ev003g.png", size=(1024, 768))


image ev004a base = Transform("ev004a.png", size=(1024, 768))

image ev004a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev004a base",
    ((config.screen_width - 1024), 0), "ev004a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev004a base") if persistent.Rez else Transform("ev004a.png", size=(1024, 768))

image ev004b base = Transform("ev004b.png", size=(1024, 768))

image ev004b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev004b base",
    ((config.screen_width - 1024), 0), "ev004b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev004b base") if persistent.Rez else Transform("ev004b.png", size=(1024, 768))

image ev004c base = Transform("ev004c.png", size=(1024, 768))

image ev004c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev004c base",
    ((config.screen_width - 1024), 0), "ev004c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev004c base") if persistent.Rez else Transform("ev004c.png", size=(1024, 768))

image ev004d base = Transform("ev004d.png", size=(1024, 768))

image ev004d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev004d base",
    ((config.screen_width - 1024), 0), "ev004d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev004d base") if persistent.Rez else Transform("ev004d.png", size=(1024, 768))


image ev005a base = Transform("ev005a.png", size=(1024, 768))

image ev005a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev005a base",
    ((config.screen_width - 1024), 0), "ev005a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev005a base") if persistent.Rez else Transform("ev005a.png", size=(1024, 768))

image ev005b base = Transform("ev005b.png", size=(1024, 768))

image ev005b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev005b base",
    ((config.screen_width - 1024), 0), "ev005b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev005b base") if persistent.Rez else Transform("ev005b.png", size=(1024, 768))

image ev005c base = Transform("ev005c.png", size=(1024, 768))

image ev005c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev005c base",
    ((config.screen_width - 1024), 0), "ev005c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev005c base") if persistent.Rez else Transform("ev005c.png", size=(1024, 768))


image ev006a base = Transform("ev006a.png", size=(1024, 768))

image ev006a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev006a base",
    ((config.screen_width - 1024), 0), "ev006a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev006a base") if persistent.Rez else Transform("ev006a.png", size=(1024, 768))

image ev006b base = Transform("ev006b.png", size=(1024, 768))

image ev006b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev006b base",
    ((config.screen_width - 1024), 0), "ev006b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev006b base") if persistent.Rez else Transform("ev006b.png", size=(1024, 768))

image ev006c base = Transform("ev006c.png", size=(1024, 768))

image ev006c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev006c base",
    ((config.screen_width - 1024), 0), "ev006c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev006c base") if persistent.Rez else Transform("ev006c.png", size=(1024, 768))

image ev006d base = Transform("ev006d.png", size=(1024, 768))

image ev006d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev006d base",
    ((config.screen_width - 1024), 0), "ev006d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev006d base") if persistent.Rez else Transform("ev006d.png", size=(1024, 768))

image ev006e base = Transform("ev006e.png", size=(1024, 768))

image ev006e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev006e base",
    ((config.screen_width - 1024), 0), "ev006e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev006e base") if persistent.Rez else Transform("ev006e.png", size=(1024, 768))


image ev007a base = Transform("ev007a.png", size=(1024, 768))

image ev007a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev007a base",
    ((config.screen_width - 1024), 0), "ev007a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev007a base") if persistent.Rez else Transform("ev007a.png", size=(1024, 768))

image ev007b base = Transform("ev007b.png", size=(1024, 768))

image ev007b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev007b base",
    ((config.screen_width - 1024), 0), "ev007b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev007b base") if persistent.Rez else Transform("ev007b.png", size=(1024, 768))

image ev007c base = Transform("ev007c.png", size=(1024, 768))

image ev007c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev007c base",
    ((config.screen_width - 1024), 0), "ev007c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev007c base") if persistent.Rez else Transform("ev007c.png", size=(1024, 768))

image ev007d base = Transform("ev007d.png", size=(1024, 768))

image ev007d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev007d base",
    ((config.screen_width - 1024), 0), "ev007d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev007d base") if persistent.Rez else Transform("ev007d.png", size=(1024, 768))

image ev007e base = Transform("ev007e.png", size=(1024, 768))

image ev007e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev007e base",
    ((config.screen_width - 1024), 0), "ev007e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev007e base") if persistent.Rez else Transform("ev007e.png", size=(1024, 768))


image ev008a base = Transform("ev008a.png", size=(1024, 768))

image ev008a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev008a base",
    ((config.screen_width - 1024), 0), "ev008a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev008a base") if persistent.Rez else Transform("ev008a.png", size=(1024, 768))

image ev008b base = Transform("ev008b.png", size=(1024, 768))

image ev008b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev008b base",
    ((config.screen_width - 1024), 0), "ev008b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev008b base") if persistent.Rez else Transform("ev008b.png", size=(1024, 768))

image ev008c base = Transform("ev008c.png", size=(1024, 768))

image ev008c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev008c base",
    ((config.screen_width - 1024), 0), "ev008c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev008c base") if persistent.Rez else Transform("ev008c.png", size=(1024, 768))

image ev008d base = Transform("ev008d.png", size=(1024, 768))

image ev008d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev008d base",
    ((config.screen_width - 1024), 0), "ev008d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev008d base") if persistent.Rez else Transform("ev008d.png", size=(1024, 768))

image ev008e base = Transform("ev008e.png", size=(1024, 768))

image ev008e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev008e base",
    ((config.screen_width - 1024), 0), "ev008e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev008e base") if persistent.Rez else Transform("ev008e.png", size=(1024, 768))

image ev008f base = Transform("ev008f.png", size=(1024, 768))

image ev008f comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev008f base",
    ((config.screen_width - 1024), 0), "ev008f base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev008f base") if persistent.Rez else Transform("ev008f.png", size=(1024, 768))

image ev008g base = Transform("ev008g.png", size=(1024, 768))

image ev008g comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev008g base",
    ((config.screen_width - 1024), 0), "ev008g base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev008g base") if persistent.Rez else Transform("ev008g.png", size=(1024, 768))


image ev009a base = Transform("ev009a.png", size=(1024, 768))

image ev009a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev009a base",
    ((config.screen_width - 1024), 0), "ev009a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev009a base") if persistent.Rez else Transform("ev009a.png", size=(1024, 768))

image ev009b base = Transform("ev009b.png", size=(1024, 768))

image ev009b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev009b base",
    ((config.screen_width - 1024), 0), "ev009b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev009b base") if persistent.Rez else Transform("ev009b.png", size=(1024, 768))

image ev009c base = Transform("ev009c.png", size=(1024, 768))

image ev009c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev009c base",
    ((config.screen_width - 1024), 0), "ev009c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev009c base") if persistent.Rez else Transform("ev009c.png", size=(1024, 768))

image ev009d base = Transform("ev009d.png", size=(1024, 768))

image ev009d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev009d base",
    ((config.screen_width - 1024), 0), "ev009d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev009d base") if persistent.Rez else Transform("ev009d.png", size=(1024, 768))


image ev010a base = Transform("ev010a.png", size=(1024, 768))

image ev010a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev010a base",
    ((config.screen_width - 1024), 0), "ev010a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev010a base") if persistent.Rez else Transform("ev010a.png", size=(1024, 768))

image ev010b base = Transform("ev010b.png", size=(1024, 768))

image ev010b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev010b base",
    ((config.screen_width - 1024), 0), "ev010b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev010b base") if persistent.Rez else Transform("ev010b.png", size=(1024, 768))

image ev010c base = Transform("ev010c.png", size=(1024, 768))

image ev010c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev010c base",
    ((config.screen_width - 1024), 0), "ev010c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev010c base") if persistent.Rez else Transform("ev010c.png", size=(1024, 768))

image ev010d base = Transform("ev010d.png", size=(1024, 768))

image ev010d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev010d base",
    ((config.screen_width - 1024), 0), "ev010d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev010d base") if persistent.Rez else Transform("ev010d.png", size=(1024, 768))

image ev010e base = Transform("ev010e.png", size=(1024, 768))

image ev010e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev010e base",
    ((config.screen_width - 1024), 0), "ev010e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev010e base") if persistent.Rez else Transform("ev010e.png", size=(1024, 768))

image ev010f base = Transform("ev010f.png", size=(1024, 768))

image ev010f comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev010f base",
    ((config.screen_width - 1024), 0), "ev010f base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev010f base") if persistent.Rez else Transform("ev010f.png", size=(1024, 768))

image ev010g base = Transform("ev010g.png", size=(1024, 768))

image ev010g comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev010g base",
    ((config.screen_width - 1024), 0), "ev010g base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev010g base") if persistent.Rez else Transform("ev010g.png", size=(1024, 768))


image ev011a base = Transform("ev011a.png", size=(1024, 768))

image ev011a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev011a base",
    ((config.screen_width - 1024), 0), "ev011a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev011a base") if persistent.Rez else Transform("ev011a.png", size=(1024, 768))

image ev011b base = Transform("ev011b.png", size=(1024, 768))

image ev011b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev011b base",
    ((config.screen_width - 1024), 0), "ev011b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev011b base") if persistent.Rez else Transform("ev011b.png", size=(1024, 768))

image ev011c base = Transform("ev011c.png", size=(1024, 768))

image ev011c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev011c base",
    ((config.screen_width - 1024), 0), "ev011c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev011c base") if persistent.Rez else Transform("ev011c.png", size=(1024, 768))

image ev011d base = Transform("ev011d.png", size=(1024, 768))

image ev011d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev011d base",
    ((config.screen_width - 1024), 0), "ev011d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev011d base") if persistent.Rez else Transform("ev011d.png", size=(1024, 768))

image ev011e base = Transform("ev011e.png", size=(1024, 768))

image ev011e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev011e base",
    ((config.screen_width - 1024), 0), "ev011e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev011e base") if persistent.Rez else Transform("ev011e.png", size=(1024, 768))


image ev012a base = Transform("ev012a.png", size=(1024, 768))

image ev012a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev012a base",
    ((config.screen_width - 1024), 0), "ev012a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev012a base") if persistent.Rez else Transform("ev012a.png", size=(1024, 768))

image ev012b base = Transform("ev012b.png", size=(1024, 768))

image ev012b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev012b base",
    ((config.screen_width - 1024), 0), "ev012b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev012b base") if persistent.Rez else Transform("ev012b.png", size=(1024, 768))

image ev012c base = Transform("ev012c.png", size=(1024, 768))

image ev012c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev012c base",
    ((config.screen_width - 1024), 0), "ev012c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev012c base") if persistent.Rez else Transform("ev012c.png", size=(1024, 768))

image ev012d base = Transform("ev012d.png", size=(1024, 768))

image ev012d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev012d base",
    ((config.screen_width - 1024), 0), "ev012d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev012d base") if persistent.Rez else Transform("ev012d.png", size=(1024, 768))


image ev013a base = Transform("ev013a.png", size=(1024, 768))

image ev013a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev013a base",
    ((config.screen_width - 1024), 0), "ev013a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev013a base") if persistent.Rez else Transform("ev013a.png", size=(1024, 768))

image ev013b base = Transform("ev013b.png", size=(1024, 768))

image ev013b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev013b base",
    ((config.screen_width - 1024), 0), "ev013b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev013b base") if persistent.Rez else Transform("ev013b.png", size=(1024, 768))

image ev013c base = Transform("ev013c.png", size=(1024, 768))

image ev013c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev013c base",
    ((config.screen_width - 1024), 0), "ev013c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev013c base") if persistent.Rez else Transform("ev013c.png", size=(1024, 768))

image ev013d base = Transform("ev013d.png", size=(1024, 768))

image ev013d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev013d base",
    ((config.screen_width - 1024), 0), "ev013d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev013d base") if persistent.Rez else Transform("ev013d.png", size=(1024, 768))


image ev014a base = Transform("ev014a.png", size=(1024, 768))

image ev014a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014a base",
    ((config.screen_width - 1024), 0), "ev014a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014a base") if persistent.Rez else Transform("ev014a.png", size=(1024, 768))

image ev014b base = Transform("ev014b.png", size=(1024, 768))

image ev014b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014b base",
    ((config.screen_width - 1024), 0), "ev014b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014b base") if persistent.Rez else Transform("ev014b.png", size=(1024, 768))

image ev014c base = Transform("ev014c.png", size=(1024, 768))

image ev014c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014c base",
    ((config.screen_width - 1024), 0), "ev014c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014c base") if persistent.Rez else Transform("ev014c.png", size=(1024, 768))

image ev014d base = Transform("ev014d.png", size=(1024, 768))

image ev014d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014d base",
    ((config.screen_width - 1024), 0), "ev014d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014d base") if persistent.Rez else Transform("ev014d.png", size=(1024, 768))

image ev014e base = Transform("ev014e.png", size=(1024, 768))

image ev014e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014e base",
    ((config.screen_width - 1024), 0), "ev014e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014e base") if persistent.Rez else Transform("ev014e.png", size=(1024, 768))

image ev014f base = Transform("ev014f.png", size=(1024, 768))

image ev014f comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014f base",
    ((config.screen_width - 1024), 0), "ev014f base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014f base") if persistent.Rez else Transform("ev014f.png", size=(1024, 768))

image ev014g base = Transform("ev014g.png", size=(1024, 768))

image ev014g comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014g base",
    ((config.screen_width - 1024), 0), "ev014g base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014g base") if persistent.Rez else Transform("ev014g.png", size=(1024, 768))

image ev014h base = Transform("ev014h.png", size=(1024, 768))

image ev014h comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014h base",
    ((config.screen_width - 1024), 0), "ev014h base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014h base") if persistent.Rez else Transform("ev014h.png", size=(1024, 768))

image ev014i base = Transform("ev014i.png", size=(1024, 768))

image ev014i comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev014i base",
    ((config.screen_width - 1024), 0), "ev014i base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev014i base") if persistent.Rez else Transform("ev014i.png", size=(1024, 768))


image ev015a base = Transform("ev015a.png", size=(1024, 768))

image ev015a comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015a base",
    ((config.screen_width - 1024), 0), "ev015a base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015a base") if persistent.Rez else Transform("ev015a.png", size=(1024, 768))

image ev015b base = Transform("ev015b.png", size=(1024, 768))

image ev015b comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015b base",
    ((config.screen_width - 1024), 0), "ev015b base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015b base") if persistent.Rez else Transform("ev015b.png", size=(1024, 768))

image ev015c base = Transform("ev015c.png", size=(1024, 768))

image ev015c comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015c base",
    ((config.screen_width - 1024), 0), "ev015c base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015c base") if persistent.Rez else Transform("ev015c.png", size=(1024, 768))

image ev015d base = Transform("ev015d.png", size=(1024, 768))

image ev015d comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015d base",
    ((config.screen_width - 1024), 0), "ev015d base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015d base") if persistent.Rez else Transform("ev015d.png", size=(1024, 768))

image ev015e base = Transform("ev015e.png", size=(1024, 768))

image ev015e comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015e base",
    ((config.screen_width - 1024), 0), "ev015e base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015e base") if persistent.Rez else Transform("ev015e.png", size=(1024, 768))

image ev015f base = Transform("ev015f.png", size=(1024, 768))

image ev015f comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015f base",
    ((config.screen_width - 1024), 0), "ev015f base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015f base") if persistent.Rez else Transform("ev015f.png", size=(1024, 768))

image ev015g base = Transform("ev015g.png", size=(1024, 768))

image ev015g comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015g base",
    ((config.screen_width - 1024), 0), "ev015g base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015g base") if persistent.Rez else Transform("ev015g.png", size=(1024, 768))

image ev015h base = Transform("ev015h.png", size=(1024, 768))

image ev015h comp = Composite(
    (config.screen_width, config.screen_height),
    (0, 0), "ev015h base",
    ((config.screen_width - 1024), 0), "ev015h base",
    (0, 0), "images/gradient.png",
    (((config.screen_width - 1024)/2), 0), "ev015h base") if persistent.Rez else Transform("ev015h.png", size=(1024, 768))

## X-Ray Definitions ##

image zcu001a base = "images/zcu001a.bmp"
image zcu001b base = "images/zcu001b.bmp"
image zcu001c base = "images/zcu001c.bmp"
image zcu001d base = "images/zcu001d.bmp"

image zcu002a base = "images/zcu002a.bmp"
image zcu002b base = "images/zcu002b.bmp"
image zcu002c base = "images/zcu002c.bmp"
image zcu002d base = "images/zcu002d.bmp"

image zcu003a base = "images/zcu003a.bmp"
image zcu003b base = "images/zcu003b.bmp"
image zcu003c base = "images/zcu003c.bmp"
image zcu003d base = "images/zcu003d.bmp"

image zcu004a base = "images/zcu004a.bmp"
image zcu004b base = "images/zcu004b.bmp"
image zcu004c base = "images/zcu004c.bmp"
image zcu004d base = "images/zcu004d.bmp"

image zcu006a = "images/zcu006a.bmp"

image zcu007a base = "images/zcu007a.bmp"
image zcu007b base = "images/zcu007b.bmp"
image zcu007c base = "images/zcu007c.bmp"
image zcu007d base = "images/zcu007d.bmp"

image zcu013a base = "images/zcu013a.png"
image zcu013b base = "images/zcu013b.png"
image zcu013c base = "images/zcu013c.png"

image zcu001b:
    parallel:
        "zcu001a base"
        0.2
        "zcu001b base" with fade
        0.4
        "zcu001c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
   
image zcu001d:
    parallel:
        "zcu001c base"
        0.2
        "zcu001d base" with fade
        0.4
        "zcu001c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
        
image zcu002b:
    parallel:
        "zcu002a base"
        0.2
        "zcu002b base" with fade
        0.4
        "zcu002c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
   
image zcu002d:
    parallel:
        "zcu002c base"
        0.2
        "zcu002d base" with fade
        0.4
        "zcu002c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
        
image zcu003b:
    parallel:
        "zcu003a base"
        0.2
        "zcu003b base" with fade
        0.4
        "zcu003c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
   
image zcu003d:
    parallel:
        "zcu003c base"
        0.2
        "zcu003d base" with fade
        0.4
        "zcu003c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
        
image zcu004b:
    parallel:
        "zcu004a base"
        0.2
        "zcu004b base" with fade
        0.4
        "zcu004c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
   
image zcu004d:
    parallel:
        "zcu004c base"
        0.2
        "zcu004d base" with fade
        0.4
        "zcu004c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
        
image zcu007b:
    parallel:
        "zcu007a base"
        0.2
        "zcu007b base" with fade
        0.4
        "zcu007c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
   
image zcu007d:
    parallel:
        "zcu007c base"
        0.2
        "zcu007d base" with fade
        0.4
        "zcu007c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
    
image zcu013b:
    parallel:
        "zcu013a base"
        0.2
        "zcu013b base" with fade
        0.4
        "zcu013c base" with fade
    parallel:
        zoom 1.0
        .2
        ease 0.2 zoom 1.01
        ease 0.2 zoom 1.0
    
## Character Sprites ##

image megumi a001 = Transform("livecomp/st_megumi_a001.png", size=(1024, 768))
image megumi a002 = Transform("livecomp/st_megumi_a002.png", size=(1024, 768))
image megumi a003 = Transform("livecomp/st_megumi_a003.png", size=(1024, 768))
image megumi a101 = Transform("livecomp/st_megumi_a101.png", size=(1024, 768))

image megumi eyes a = Transform("livecomp/megumi_eyes_a.png", size=(200, 280))
image megumi eyes c = Transform("livecomp/megumi_eyes_c.png", size=(200, 280))
image megumi eyes d = Transform("livecomp/megumi_eyes_d.png", size=(200, 280))
image megumi eyes e = Transform("livecomp/megumi_eyes_e.png", size=(200, 280))
image megumi eyes f = Transform("livecomp/megumi_eyes_f.png", size=(200, 280))
image megumi eyes g = Transform("livecomp/megumi_eyes_g.png", size=(200, 280))
image megumi eyes closed = "livecomp/megumi_eyes_b.png"

image megumi mouth a = Transform("livecomp/megumi_mouth_a.png", size=(200, 280))
image megumi mouth b = Transform("livecomp/megumi_mouth_b.png", size=(200, 280))
image megumi mouth c = Transform("livecomp/megumi_mouth_c.png", size=(200, 280))
image megumi mouth d = Transform("livecomp/megumi_mouth_d.png", size=(200, 280))
image megumi mouth e = Transform("livecomp/megumi_mouth_e.png", size=(200, 280))
image megumi mouth f = Transform("livecomp/megumi_mouth_f.png", size=(200, 280))
image megumi mouth g = Transform("livecomp/megumi_mouth_g.png", size=(200, 280))

image megumi brow a = Transform("livecomp/megumi_brow_a.png", size=(200, 280))
image megumi brow b = Transform("livecomp/megumi_brow_b.png", size=(200, 280))
image megumi brow c = Transform("livecomp/megumi_brow_c.png", size=(200, 280))
image megumi brow d = Transform("livecomp/megumi_brow_d.png", size=(200, 280))
image megumi brow e = Transform("livecomp/megumi_brow_e.png", size=(200, 280))
image megumi brow f = Transform("livecomp/megumi_brow_f.png", size=(200, 280))
image megumi brow g = Transform("livecomp/megumi_brow_g.png", size=(200, 280))

## Face Animations ##

## Blink ##

image megumi blink a:
    "megumi eyes a"
    renpy.random.randint(4,6)
    "megumi eyes c"
    .02
    "megumi eyes closed"
    .08
    "megumi eyes c"
    .02
    repeat
    
image megumi blink b:
    "megumi eyes closed"
    
image megumi blink c:
    "megumi eyes c"
    renpy.random.randint(4,6)
    "megumi eyes closed"
    .08
    repeat
    
image megumi blink d:
    "megumi eyes d"
    renpy.random.randint(4,6)
    "megumi eyes c"
    .02
    "megumi eyes closed"
    .08
    "megumi eyes c"
    .02
    repeat
    
image megumi blink e:
    "megumi eyes e"
    renpy.random.randint(4,6)
    .02
    "megumi eyes closed"
    .08
    repeat
    
image megumi blink f:
    "megumi eyes f"
    renpy.random.randint(4,6)
    "megumi eyes c"
    .02
    "megumi eyes closed"
    .08
    "megumi eyes c"
    .02
    repeat
    
image megumi blink g:
    "megumi eyes g"
    renpy.random.randint(4,6)
    "megumi eyes closed"
    .08
    repeat
    
## Talk ##

image megumi talk a:
    "megumi mouth a"
    .1
    "megumi mouth g"
    .1
    "megumi mouth b"
    .1
    "megumi mouth g"
    .1
    repeat
    
image megumi talk b:
    "megumi mouth b"
    .1
    "megumi mouth g"
    .1
    "megumi mouth a"
    .1
    "megumi mouth g"
    .1
    repeat

image megumi talk c:
    "megumi mouth c"
    .1
    "megumi mouth e"
    .1
    "megumi mouth a"
    .1
    "megumi mouth e"
    .1
    repeat
    
image megumi talk d:
    "megumi mouth d"
    .1
    "megumi mouth e"
    .1
    "megumi mouth d"
    .1
    "megumi mouth a"
    .1
    repeat
    
image megumi talk e:
    "megumi mouth e"
    .1
    "megumi mouth d"
    .1
    "megumi mouth a"
    .1
    "megumi mouth d"
    .1
    repeat
    
image megumi talk f:
    "megumi mouth f"
    .1
    "megumi mouth c"
    .1
    "megumi mouth a"
    .1
    "megumi mouth c"
    .1
    repeat
    
image megumi talk g:
    "megumi mouth g"
    .1
    "megumi mouth a"
    .1
    "megumi mouth g"
    .1
    "megumi mouth b"
    .1
    repeat
    
## Live Composite ##
    
## Regular ##

image megumi a001 a = Composite(
    (1024, 768),
    (0, 0), "megumi a001",
    (412, 0), "megumi brow a",
    (412, 0), "megumi blink a" if persistent.face_anim else "megumi eyes a",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk a", "megumi mouth a")) if persistent.face_anim else "megumi mouth a")
    
image megumi a001 b = Composite(
    (1024, 768),
    (0, 0), "megumi a001",
    (412, 0), "megumi brow b",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk b", "megumi mouth b")) if persistent.face_anim else "megumi mouth b")
    
image megumi a001 c = Composite(
    (1024, 768),
    (0, 0), "megumi a001",
    (412, 0), "megumi brow c",
    (412, 0), "megumi blink c" if persistent.face_anim else "megumi eyes c",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk c", "megumi mouth c")) if persistent.face_anim else "megumi mouth c")
    
image megumi a001 d = Composite(
    (1024, 768),
    (0, 0), "megumi a001",
    (412, 0), "megumi brow d",
    (412, 0), "megumi blink d" if persistent.face_anim else "megumi eyes d",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk d", "megumi mouth d")) if persistent.face_anim else "megumi mouth d")
    
image megumi a001 e = Composite(
    (1024, 768),
    (0, 0), "megumi a001",
    (412, 0), "megumi brow e",
    (412, 0), "megumi blink e" if persistent.face_anim else "megumi eyes e",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk e", "megumi mouth e")) if persistent.face_anim else "megumi mouth e")
    
image megumi a001 f = Composite(
    (1024, 768),
    (0, 0), "megumi a001",
    (412, 0), "megumi brow f",
    (412, 0), "megumi blink f" if persistent.face_anim else "megumi eyes f",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk f", "megumi mouth f")) if persistent.face_anim else "megumi mouth f")
    
image megumi a001 g = Composite(
    (1024, 768),
    (0, 0), "megumi a001",
    (412, 0), "megumi brow g",
    (412, 0), "megumi blink g" if persistent.face_anim else "megumi eyes g",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk g", "megumi mouth g")) if persistent.face_anim else "megumi mouth g")
    
## Kimono ##

image megumi a002 a = Composite(
    (1024, 768),
    (0, 0), "megumi a002",
    (412, 0), "megumi brow a",
    (412, 0), "megumi blink a" if persistent.face_anim else "megumi eyes a",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk a", "megumi mouth a")) if persistent.face_anim else "megumi mouth a")
    
image megumi a002 b = Composite(
    (1024, 768),
    (0, 0), "megumi a002",
    (412, 0), "megumi brow b",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk b", "megumi mouth b")) if persistent.face_anim else "megumi mouth b")
    
image megumi a002 c = Composite(
    (1024, 768),
    (0, 0), "megumi a002",
    (412, 0), "megumi brow c",
    (412, 0), "megumi blink c" if persistent.face_anim else "megumi eyes c",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk c", "megumi mouth c")) if persistent.face_anim else "megumi mouth c")
    
image megumi a002 d = Composite(
    (1024, 768),
    (0, 0), "megumi a002",
    (412, 0), "megumi brow d",
    (412, 0), "megumi blink d" if persistent.face_anim else "megumi eyes d",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk d", "megumi mouth d")) if persistent.face_anim else "megumi mouth d")
    
image megumi a002 e = Composite(
    (1024, 768),
    (0, 0), "megumi a002",
    (412, 0), "megumi brow e",
    (412, 0), "megumi blink e" if persistent.face_anim else "megumi eyes e",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk e", "megumi mouth e")) if persistent.face_anim else "megumi mouth e")
    
image megumi a002 f = Composite(
    (1024, 768),
    (0, 0), "megumi a002",
    (412, 0), "megumi brow f",
    (412, 0), "megumi blink f" if persistent.face_anim else "megumi eyes f",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk f", "megumi mouth f")) if persistent.face_anim else "megumi mouth f")
    
image megumi a002 g = Composite(
    (1024, 768),
    (0, 0), "megumi a002",
    (412, 0), "megumi brow g",
    (412, 0), "megumi blink g" if persistent.face_anim else "megumi eyes g",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk g", "megumi mouth g")) if persistent.face_anim else "megumi mouth g")
    
## Naked ##
    
image megumi a003 a = Composite(
    (1024, 768),
    (0, 0), "megumi a003",
    (412, 0), "megumi brow a",
    (412, 0), "megumi blink a" if persistent.face_anim else "megumi eyes a",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk a", "megumi mouth a")) if persistent.face_anim else "megumi mouth a")
    
image megumi a003 b = Composite(
    (1024, 768),
    (0, 0), "megumi a003",
    (412, 0), "megumi brow b",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk b", "megumi mouth b")) if persistent.face_anim else "megumi mouth b")
    
image megumi a003 c = Composite(
    (1024, 768),
    (0, 0), "megumi a003",
    (412, 0), "megumi brow c",
    (412, 0), "megumi blink c" if persistent.face_anim else "megumi eyes c",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk c", "megumi mouth c")) if persistent.face_anim else "megumi mouth c")
    
image megumi a003 d = Composite(
    (1024, 768),
    (0, 0), "megumi a003",
    (412, 0), "megumi brow d",
    (412, 0), "megumi blink d" if persistent.face_anim else "megumi eyes d",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk d", "megumi mouth d")) if persistent.face_anim else "megumi mouth d")
    
image megumi a003 e = Composite(
    (1024, 768),
    (0, 0), "megumi a003",
    (412, 0), "megumi brow e",
    (412, 0), "megumi blink e" if persistent.face_anim else "megumi eyes e",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk e", "megumi mouth e")) if persistent.face_anim else "megumi mouth e")
    
image megumi a003 f = Composite(
    (1024, 768),
    (0, 0), "megumi a003",
    (412, 0), "megumi brow f",
    (412, 0), "megumi blink f" if persistent.face_anim else "megumi eyes f",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk f", "megumi mouth f")) if persistent.face_anim else "megumi mouth f")

image megumi a003 g = Composite(
    (1024, 768),
    (0, 0), "megumi a003",
    (412, 0), "megumi brow g",
    (412, 0), "megumi blink g" if persistent.face_anim else "megumi eyes g",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk g", "megumi mouth g")) if persistent.face_anim else "megumi mouth g")
    
## Pregnant ##

image megumi a101 a = Composite(
    (1024, 768),
    (0, 0), "megumi a101",
    (412, 0), "megumi brow a",
    (412, 0), "megumi blink a" if persistent.face_anim else "megumi eyes a",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk a", "megumi mouth a")) if persistent.face_anim else "megumi mouth a")
    
image megumi a101 b = Composite(
    (1024, 768),
    (0, 0), "megumi a101",
    (412, 0), "megumi brow b",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk b", "megumi mouth b")) if persistent.face_anim else "megumi mouth b")
    
image megumi a101 c = Composite(
    (1024, 768),
    (0, 0), "megumi a101",
    (412, 0), "megumi brow c",
    (412, 0), "megumi blink c" if persistent.face_anim else "megumi eyes c",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk c", "megumi mouth c")) if persistent.face_anim else "megumi mouth c")
    
image megumi a101 d = Composite(
    (1024, 768),
    (0, 0), "megumi a101",
    (412, 0), "megumi brow d",
    (412, 0), "megumi blink d" if persistent.face_anim else "megumi eyes d",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk d", "megumi mouth d")) if persistent.face_anim else "megumi mouth d")
    
image megumi a101 e = Composite(
    (1024, 768),
    (0, 0), "megumi a101",
    (412, 0), "megumi brow e",
    (412, 0), "megumi blink e" if persistent.face_anim else "megumi eyes e",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk e", "megumi mouth e")) if persistent.face_anim else "megumi mouth e")
    
image megumi a101 f = Composite(
    (1024, 768),
    (0, 0), "megumi a101",
    (412, 0), "megumi brow f",
    (412, 0), "megumi blink f" if persistent.face_anim else "megumi eyes f",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk f", "megumi mouth f")) if persistent.face_anim else "megumi mouth f")
    
image megumi a101 g = Composite(
    (1024, 768),
    (0, 0), "megumi a101",
    (412, 0), "megumi brow g",
    (412, 0), "megumi blink g" if persistent.face_anim else "megumi eyes g",
    (412, 0), (WhileSpeaking("Megumi", "megumi talk g", "megumi mouth g")) if persistent.face_anim else "megumi mouth g")